<?php

namespace Database\Factories;

use App\Models\PurchaseOrderLine;
use App\Models\PurchaseOrderShipment;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\PurchaseOrderShipmentLine>
 */
class PurchaseOrderShipmentLineFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        /*
         * Note PurchaseOrderShipmentLine will not work without the purchase_order_line_id
         * so this factory can only be used by utilizing the state override to set the
         * purchase_order_line_id to be the appropriate sibling id
         */
        return [
            'purchase_order_line_id' => PurchaseOrderLine::factory(),
            'purchase_order_shipment_id' => PurchaseOrderShipment::factory(),
            'quantity' => $this->faker->numberBetween(1, 10),
        ];
    }
}
