<?php

namespace Database\Factories;

use App\Models\PurchaseOrder;
use App\Models\PurchaseOrderLine;
use App\Models\PurchaseOrderShipmentLine;
use App\Models\PurchaseOrderShipmentReceipt;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Database\Eloquent\Factories\Sequence;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\PurchaseOrderShipment>
 */
class PurchaseOrderShipmentFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'purchase_order_id' => PurchaseOrder::factory(),
            'shipment_date' => now(),
        ];
    }

    public function shipped(int $numLines)
    {
        return
            $this
                ->has(
                    PurchaseOrderShipmentLine::factory($numLines)
                        ->state(new Sequence(
                            fn ($sequence) => [
                                'purchase_order_line_id' => ($line = PurchaseOrderLine::offset($sequence->index)->first())->id,
                                'quantity' => $line->quantity,
                            ]
                        )
                        )
                );
    }

    public function received(int $numLines)
    {
        return
            $this
                ->has(
                    PurchaseOrderShipmentReceipt::factory()->received($numLines)
                );
    }
}
