<?php

namespace Database\Factories;

use App\Models\Product;
use App\Models\ProductPricingTier;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\ProductPricing>
 */
class ProductPricingFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'product_pricing_tier_id' => ProductPricingTier::default()->id,
            'product_id' => Product::factory(),
            'price' => $this->faker->randomFloat(2, 5, 100),
        ];
    }
}
