<?php

namespace Database\Factories;

use App\Models\Product;
use App\Models\SalesChannel;
use Illuminate\Database\Eloquent\Factories\Factory;

class ProductListingFactory extends Factory
{
    /**
     * Define the model's default state.
     */
    public function definition(): array
    {
        return [
            'product_id' => Product::factory(),
            'sales_channel_id' => SalesChannel::factory(),
            'sales_channel_listing_id' => $this->faker->randomNumber(),
            'listing_sku' => $this->faker->ean13(),
            'price' => $this->faker->randomFloat(1, 0, 100),
            'is_fba' => false,
        ];
    }

    public function fBA()
    {
        return $this->state(['is_fba' => true]);
    }
}
