<?php

namespace Database\Factories;

use App\Models\Product;
use App\Models\ProductInventory;
use App\Models\Warehouse;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Carbon;

class ProductInventoryFactory extends Factory
{
    protected $model = ProductInventory::class;

    public function definition(): array
    {
        return [
            'inventory_total' => $this->faker->numberBetween(1, 10), //
            'inventory_reserved' => $this->faker->numberBetween(1, 10),
            'inventory_in_transit' => $this->faker->numberBetween(1, 10),
            'inventory_available' => $this->faker->numberBetween(1, 10),
            'inventory_stock_value' => $this->faker->randomFloat(2, 5, 150),
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now(),
            'product_id' => Product::factory(),
            'warehouse_id' => Warehouse::factory(),
        ];
    }
}
