<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

class ProductImageFactory extends Factory
{
    /**
     * Define the model's default state.
     */
    public function definition(): array
    {
        return [
            'url' => $this->faker->imageUrl(),
            'name' => $this->faker->colorName(),
            'sort_order' => $this->faker->randomNumber(1),
            'is_primary' => $this->faker->boolean(),
        ];
    }

    public function primary()
    {
        return $this->state(['is_primary' => true]);
    }
}
