<?php

namespace Database\Factories;

use App\Models\ProductCategory;
use Illuminate\Database\Eloquent\Factories\Factory;

// archived product category
// unarchived product category

// levels

class ProductCategoryFactory extends Factory
{
    /**
     * Define the model's default state.
     */
    public function definition(): array
    {
        return [
            'name' => $this->faker->company(),
        ];
    }

    public function archived()
    {
        return $this->state(function () {
            return [
                'archived_at' => $this->faker->dateTimeThisMonth(),
            ];
        });
    }

    public function unarchived()
    {
        return $this->state(['archived_at' => null]);
    }

    public function level2()
    {
        return $this->state(function () {
            return ['parent_id' => ProductCategory::factory()];
        });
    }

    public function level3()
    {
        return $this->state(function () {
            return ['parent_id' => ProductCategory::factory()->level2()];
        });
    }

    public function level4()
    {
        return $this->state(function () {
            return ['parent_id' => ProductCategory::factory()->level3()];
        });
    }
}
