<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

// archived product brand
// unarchived product brand

class ProductBrandFactory extends Factory
{
    /**
     * Define the model's default state.
     */
    public function definition(): array
    {
        return [
            'name' => $this->faker->unique()->company().' '.$this->faker->randomNumber(5),
        ];
    }

    public function archived()
    {
        return $this->state(function () {
            return [
                'archived_at' => $this->faker->dateTimeThisMonth(),
            ];
        });
    }

    public function unarchived()
    {
        return $this->state(['archived_at' => null]);
    }
}
