<?php

namespace Database\Factories;

use App\Enums\FinancialLineProrationStrategyEnum;
use App\Models\FinancialLine;
use App\Models\FinancialLineType;
use App\Models\SalesOrder;
use Illuminate\Database\Eloquent\Factories\Factory;

/** @mixin FinancialLine */
class FinancialLineFactory extends Factory
{
    public function definition(): array
    {
        return [
            'sales_order_id' => SalesOrder::factory(),
            'financial_line_type_id' => FinancialLineType::factory(),
            'description' => $this->faker->text,
            'quantity' => $this->faker->numberBetween(1, 10),
            'amount' => $this->faker->randomFloat(2, 1, 1000),
            'proration_strategy' => FinancialLineProrationStrategyEnum::REVENUE_BASED,
            'sales_channel_line_id' => null,
            'allocate_to_products' => false,
        ];
    }
}
