<?php

namespace Database\Factories;

use App\Models\Attribute;
use Illuminate\Database\Eloquent\Factories\Factory;

// has options
// archived attribute
// unarchived attribute

class AttributeFactory extends Factory
{
    /**
     * Define the model's default state.
     */
    public function definition(): array
    {
        return [
            'name' => $this->faker->words(3, true),
            'type' => $this->faker->randomElement(Attribute::TYPES),
            'display' => ['has_options' => false],
        ];
    }

    public function hasOptions()
    {
        return $this->state(['display' => ['has_options' => true]]);
    }

    public function archived()
    {
        return $this->state(function () {
            return ['archived_at' => $this->faker->dateTimeThisMonth()];
        });
    }

    public function unarchived()
    {
        return $this->state(['archived_at' => null]);
    }
}
