<?php

namespace Database\Factories;

use App\Models\AccountingTransaction;
use App\Models\NominalCode;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\AccountingTransactionLine>
 */
class AccountingTransactionLineFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'accounting_transaction_id' => AccountingTransaction::factory(),
            'nominal_code_id' => NominalCode::factory(),
            'type' => null,
            'description' => $this->faker->sentence(),
            'quantity' => $this->faker->numberBetween(5, 10),
            'amount' => $this->faker->numberBetween(100, 200),
        ];
    }
}
