<?php

namespace Database\Factories;

use App\Enums\AccountingTransactionLineTypeEnum;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\AccountingTransaction>
 */
class AccountingTransactionFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'transaction_date' => now()->subMinute(),
            'type' => $this->faker->randomElement(AccountingTransactionLineTypeEnum::cases()),
            'reference' => $this->faker->sentence(),
            'name' => $this->faker->name(),
            'email' => $this->faker->email(),
            'total' => $this->faker->numberBetween(10, 100),
            'currency_code' => 'USD',
            'currency_rate' => 1,
            'is_sync_enabled' => true
        ];
    }
}
