<?php

$index_prefix = env('SPHINX_INDEX_PREFIX', 'sku_');
$gateway_db = env('SPHINX_GATEWAY_DB', 'sphinx');
$connection = env('SPHINX_CONNECTION', 'sphinx');
$host = env('SPHINX_HOST', '127.0.0.1');
$api_port = env('SPHINX_API_PORT', '9312');
$enabled = env('SPHINX_ENABLED', false);

if (! defined('SPHINX_INDEX_PREFIX')) {
    define('SPHINX_INDEX_PREFIX', $index_prefix);
}

return [
    /*
  |--------------------------------------------------------------------------
  | SphinxSearch indexes
  |--------------------------------------------------------------------------
  |
  | Description
  |
  */
    'indexes' => env('SPHINX_INDEXES', ''),
    'index_prefix' => $index_prefix,
    'enabled' => $enabled,
    'connection' => $connection,
    'gateway_db' => $gateway_db,
    'index_config' => [
        $index_prefix.'products' => [
            'gateway_table' => $index_prefix.'products',
            'setup_sql' => [
                'DROP TABLE IF EXISTS '.$gateway_db.'.'.$index_prefix.'products;',
                'CREATE TABLE '.$gateway_db.'.'.$index_prefix.'products
              (
                  id BIGINT UNSIGNED NOT NULL,
                  weight  INTEGER NOT NULL,
                  query   VARCHAR(3072) NOT NULL,
                  parent_id INTEGER,
                  brand_id  INTEGER,
                  INDEX(query)
              ) ENGINE=SPHINX CONNECTION="'.
                $connection.'://'.
                $host.':'.
                $api_port.
                '/'.$index_prefix.'products";',
            ],
            'rebuild_sql' => 'SELECT id, sku, name, barcode, mpn, parent_id, brand_id FROM products',
        ],

        $index_prefix.'product_attributes' => [
            'gateway_table' => $index_prefix.'product_attributes',
            'setup_sql' => [
                'DROP TABLE IF EXISTS '.$gateway_db.'.'.$index_prefix.'product_attributes;',
                'CREATE TABLE '.$gateway_db.'.'.$index_prefix.'product_attributes
              (
                  id BIGINT UNSIGNED NOT NULL,
                  weight  INTEGER NOT NULL,
                  query   VARCHAR(3072) NOT NULL,
                  product_id   INTEGER,
                  attribute_id INTEGER,
                  INDEX(query)
              ) ENGINE=SPHINX CONNECTION="'.
                $connection.'://'.
                $host.':'.
                $api_port.
                '/'.$index_prefix.'product_attributes";',
            ],
            'rebuild_sql' => 'SELECT id, value, product_id, attribute_id FROM product_attributes',
        ],
    ],
];
