<?php
/**
 * All Sales Channels OAuth configurations.
 *
 * We have many requirements for OAuth authentication will store here.
 *
 * "redirect_uri" will store without domain to edit dynamically.
 *
 * "oauth_scopes" our app permissions.
 */
return [
    /**
     * eBay.
     *
     * "redirect_uri" will store on eBay User Tokens dashboard.
     */
    'ebay' => [
        'redirect_uri' => 'ebay-auth-accepted',
        'oauth_scopes' => [
            'https://api.ebay.com/oauth/api_scope/sell.account',
            'https://api.ebay.com/oauth/api_scope/sell.inventory',
            'https://api.ebay.com/oauth/api_scope/sell.fulfillment',
        ],
    ],

    /**
     * Shopify.
     *
     * "redirect_uri" store in Whitelisted redirection URL(s) on partners dashboard
     */
    'shopify' => [
        'redirect_uri' => 'shopify-auth-accepted',
        'oauth_scopes' => [
            'read_content',
            'read_products',
            'write_products',
            'read_orders',
            'read_draft_orders',
            'read_shipping',
        ],
    ],

    /**
     * Walmart.
     */
    'walmart' => [
        'redirect_uri' => '/#/walmart-auth-accepted',
        'oauth_scopes' => [
            'openId',
        ],
    ],

    /**
     * Google Express.
     */
    'google_express' => [
        'redirect_uri' => 'google-express-auth-accepted',
        'oauth_scopes' => [
            'https://www.googleapis.com/auth/content',
        ],
    ],

    /**
     * Magento.
     *
     * different way
     */
    'magento' => [
        'callback_url' => '/api/channels/magento/endpoint',
        'identity_link_url' => '/api/channels/magento/auth-accepted',
    ],
];
