<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Default Filesystem Disk
    |--------------------------------------------------------------------------
    |
    | Here you may specify the default filesystem disk that should be used
    | by the framework. The "local" disk, as well as a variety of cloud
    | based disks are available to your application. Just store away!
    |
    */

    'default' => env('FILESYSTEM_DISK', 'local'),

    /*
    |--------------------------------------------------------------------------
    | Filesystem Disks
    |--------------------------------------------------------------------------
    |
    | Here you may configure as many filesystem "disks" as you wish, and you
    | may even configure multiple disks of the same driver. Defaults have
    | been set up for each driver as an example of the required values.
    |
    | Supported Drivers: "local", "ftp", "sftp", "s3"
    |
    */

    'disks' => [

        'local' => [
            'driver' => 'local',
            'root' => storage_path('app'),
            'throw' => false,
        ],

        'public' => [
            'driver' => 'local',
            'root' => storage_path('app/public'),
            'url' => env('APP_URL').'/storage',
            'visibility' => 'public',
            'throw' => false,
        ],

        'images' => [
            'driver' => 'local',
            'root' => storage_path('app/public/images/'),
            'url' => '/storage/images/',
            'visibility' => 'public',
        ],

        'reports' => [
            'driver' => 'local',
            'root' => storage_path('app/public/reports/'),
            'url' => '/storage/reports/',
            'visibility' => 'public',
        ],

        'fulfillment_packing_slips' => [
            'driver' => 'local',
            'root' => storage_path('app/public/reports/fulfillment_packing_slips/'),
            'url' => '/storage/reports/fulfillment_packing_slips/',
            'visibility' => 'public',
        ],

        'order_packing_slips' => [
            'driver' => 'local',
            'root' => storage_path('app/public/reports/sales_order_packing_slips/'),
            'url' => '/storage/reports/sales_order_packing_slips/',
            'visibility' => 'public',
        ],

        'model-imports' => [
            'driver' => 'local',
            'root' => storage_path('imports/models'),
            'visibility' => 'public',
        ],

        'sales-channel-product-mappings' => [
            'driver' => 'local',
            'root' => storage_path('imports/sales_channel_product_mappings'),
            'visibility' => 'public',
        ],

        'smo-invoices' => [
            'driver' => 'local',
            'root' => storage_path('imports/smo_invoices'),
            'visibility' => 'public',
        ],

        'shopify' => [
            'driver' => 'local',
            'root' => storage_path('app/shopify'),
            'visibility' => 'public',
        ],

        'model-exports' => [
            'driver' => 'local',
            'root' => storage_path('exports'),
            'visibility' => 'public',
        ],

        'amazon_reports' => [
            'driver' => 'local',
            'root' => storage_path('app/amazon_reports'),
            'visibility' => 'public',
        ],

        'export' => [
            'driver' => 'local',
            'root' => storage_path('app/public/export/'),
            'url' => '/storage/export/',
            'visibility' => 'public',
        ],

        'importing_errors' => [
            'driver' => 'local',
            'root' => storage_path('app/public/importing_errors/'),
            'url' => env('APP_URL').'/storage/importing_errors/',
            'visibility' => 'public',
        ],

        'po_pdf' => [
            'driver' => 'local',
            'root' => storage_path('app/purchase_orders_pdf'),
            'visibility' => 'public',
        ],

        'jasper_reports' => [
            'driver' => 'local',
            'root' => storage_path('app/jasper_reports'),
            'visibility' => 'public',
        ],

        's3' => [
            'driver' => 's3',
            'key' => env('AWS_ACCESS_KEY_ID'),
            'secret' => env('AWS_SECRET_ACCESS_KEY'),
            'region' => env('AWS_DEFAULT_REGION'),
            'bucket' => env('AWS_BUCKET'),
            'url' => env('AWS_URL'),
            'endpoint' => env('AWS_ENDPOINT'),
            'use_path_style_endpoint' => env('AWS_USE_PATH_STYLE_ENDPOINT', false),
            'throw' => false,
        ],

    ],

    /*
    |--------------------------------------------------------------------------
    | Symbolic Links
    |--------------------------------------------------------------------------
    |
    | Here you may configure the symbolic links that will be created when the
    | `storage:link` Artisan command is executed. The array keys should be
    | the locations of the links and the values should be their targets.
    |
    */

    'links' => [
        public_path('storage') => storage_path('app/public'),
    ],

];
