<?php

$fields = [
    'sku' => 'string',
    'woo_commerce_id' => 'integer',
    'name' => 'string',
    'slug' => 'string',
    'price' => 'decimal',
    'type' => 'string',
    'date_created_gmt' => 'string',
    'date_modified_gmt' => 'string',
    'status' => 'string',
    'featured' => 'string',
    'catalog_visibility' => 'string',
    'weight' => 'string',
    'dimensions_length' => 'string',
    'dimensions_width' => 'string',
    'dimensions_height' => 'string',
    'product' => 'product',
    'created_at' => 'date/time',
    'updated_at' => 'date/time',
];

$visible = \Illuminate\Support\Arr::except($fields, ['created_at', 'updated_at']);

$filterable = $fields;
$sortable = $filterable;

$specialLabels = [
    'sku' => 'SKU',
    'woo_commerce_id' => 'ID',
    'date_created_gmt' => 'Created Date',
    'date_modified_gmt' => 'Updated Date',
    'dimensions_length' => 'Length',
    'dimensions_width' => 'Width',
    'dimensions_height' => 'Height',
];

$labels = [];
foreach (array_keys($fields) as $field) {
    if (array_key_exists($field, $specialLabels)) {
        $labels[$field] = $specialLabels[$field];
    } else {
        $labels[$field] = ucwords(str_replace('_', ' ', $field));
    }
}

$order = 1;
$columns = [];
foreach ($fields as $field => $type)
{
    $columns[] = [
        'data_name' => $field,
        'column_label' => $labels[$field],
        'default_order' => $order++,
        'group' => 'Basic Info',
        'group_data' => 'basic_info',
        'default_visible' => $visible[$field] ?? 0,
        'sortable' => $sortable[$field] ?? 0,
        'editable' => 0,
        'filterable' => $filterable[$field] ?? 0,
        'dropdown' => 0,
        'type' => $type,
    ];
}

return [
    'rows_deletable' => 0,
    'frozen_columns' => ['sku'],
    'default_sort' => [['field' => 'created_at', 'sort' => 'DESC']],
    'default_density' => 'compact',
    'columns' => $columns
];
