<?php

return [
    'rows_deletable' => 1,
    'frozen_columns' => ['basic_info', 'po_number'],
    'default_sort' => [['field' => 'created_at', 'sort' => 'DESC']],
    'default_density' => 'expanded',
    'columns' => [
        //-----------------------------------------------------
        // Basic Info
        //-----------------------------------------------------

        [
            'data_name' => 'basic_info',
            'column_label' => 'Basic Info',
            'default_order' => 0,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 0,
            'dropdown' => 0,
            'type' => 'basic_order_info',
        ],
        [
            'data_name' => 'po_number',
            'column_label' => 'PO #',
            'default_order' => 1,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'id',
            'column_label' => 'Internal ID',
            'default_order' => 2,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'integer',
        ],
        [
            /** @see https://siberventures.atlassian.net/browse/SKU-1317 */
            'data_name' => 'purchase_order_date',
            'column_label' => 'Order Date',
            'default_order' => 3,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'date',
        ],
        [
            'data_name' => 'payment_term',
            'column_label' => 'Payment Term',
            'default_order' => 4,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'incoterm',
            'column_label' => 'Incoterm',
            'default_order' => 5,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'submission_format',
            'column_label' => 'Submission Format',
            'default_order' => 6,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'is_tax_included',
            'column_label' => 'Tax Included?',
            'default_order' => 6,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 0,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'checkbox',
        ],
        [
            'data_name' => 'created_at',
            'column_label' => 'Created At',
            'default_order' => 7,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'date',
        ],
        [
            'data_name' => 'updated_at',
            'column_label' => 'Updated At',
            'default_order' => 8,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'date',
        ],
        [
            'data_name' => 'archived_at',
            'column_label' => 'Archived At',
            'default_order' => 9,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'date',
        ],

        //-----------------------------------------------------
        // Fulfillment Info
        //-----------------------------------------------------

        [
            'data_name' => 'fulfillment_info',
            'column_label' => 'Fulfillment',
            'default_order' => 10,
            'group' => 'Fulfillment',
            'group_data' => 'fulfillment_info',
            'default_visible' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 0,
            'dropdown' => 0,
            'only_grouped' => 1,
            'type' => 'fulfillment_info',
        ],
        [
            'data_name' => 'estimated_delivery_date',
            'column_label' => 'ETA',
            'default_order' => 11,
            'group' => 'Fulfillment',
            'group_data' => 'fulfillment_info',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'date/time',
        ],
        [
            'data_name' => 'shipping_method',
            'column_label' => 'Shipping Method',
            'default_order' => 12,
            'group' => 'Fulfillment',
            'group_data' => 'fulfillment_info',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'requested_shipping_method',
            'column_label' => 'Requested Shipping Method',
            'default_order' => 12,
            'group' => 'Fulfillment',
            'group_data' => 'fulfillment_info',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'shipment_tracking',
            'column_label' => 'Shipment Tracking',
            'default_order' => 13,
            'group' => 'Fulfillment',
            'group_data' => 'fulfillment_info',
            'default_visible' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'shipment_shipping_method',
            'column_label' => 'Shipment Shipping Method',
            'default_order' => 14,
            'group' => 'Fulfillment',
            'group_data' => 'fulfillment_info',
            'default_visible' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'decimal',
        ],
        [
            'data_name' => 'shipment_date',
            'column_label' => 'Shipment Date',
            'default_order' => 15,
            'group' => 'Fulfillment',
            'group_data' => 'fulfillment_info',
            'default_visible' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'date/time',
        ],
        [
            'data_name' => 'shipment_quantity',
            'column_label' => 'Shipment Item Qty',
            'default_order' => 16,
            'group' => 'Fulfillment',
            'group_data' => 'fulfillment_info',
            'default_visible' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'decimal',
        ],
        [
            'data_name' => 'shipment_received',
            'column_label' => 'Shipment Received',
            'default_order' => 17,
            'group' => 'Fulfillment',
            'group_data' => 'fulfillment_info',
            'default_visible' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'decimal',
        ],
        [
            'data_name' => 'tracking_number',
            'column_label' => 'Tracking #',
            'default_order' => 68,
            'group' => 'Fulfillment',
            'group_data' => 'fulfillment_info',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'fully_received_at',
            'column_label' => 'Fully Received At',
            'default_order' => 68,
            'group' => 'Fulfillment',
            'group_data' => 'fulfillment_info',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'date',
        ],

        //-----------------------------------------------------
        // Supplier Info
        //-----------------------------------------------------

        [
            'data_name' => 'supplier_info',
            'column_label' => 'Supplier',
            'default_order' => 18,
            'group' => 'Supplier',
            'group_data' => 'supplier_info',
            'default_visible' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 0,
            'dropdown' => 0,
            'type' => 'supplier_info',
        ],
        [
            'data_name' => 'supplier_name',
            'column_label' => 'Supplier Name',
            'default_order' => 19,
            'group' => 'Supplier',
            'group_data' => 'supplier_info',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'supplier',
        ],
        [
            'data_name' => 'supplier_email',
            'column_label' => 'Supplier Email',
            'default_order' => 20,
            'group' => 'Supplier',
            'group_data' => 'supplier_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'supplier_po_email',
            'column_label' => 'Supplier PO Email',
            'default_order' => 21,
            'group' => 'Supplier',
            'group_data' => 'supplier_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'supplier_company',
            'column_label' => 'Supplier Company',
            'default_order' => 22,
            'group' => 'Supplier',
            'group_data' => 'supplier_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'supplier_contact',
            'column_label' => 'Supplier Contact',
            'default_order' => 23,
            'group' => 'Supplier',
            'group_data' => 'supplier_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'supplier_phone',
            'column_label' => 'Supplier Phone',
            'default_order' => 24,
            'group' => 'Supplier',
            'group_data' => 'supplier_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'supplier_address',
            'column_label' => 'Supplier Address',
            'default_order' => 25,
            'group' => 'Supplier',
            'group_data' => 'supplier_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'supplier_city',
            'column_label' => 'Supplier City',
            'default_order' => 26,
            'group' => 'Supplier',
            'group_data' => 'supplier_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'supplier_province',
            'column_label' => 'Supplier State/Province',
            'default_order' => 27,
            'group' => 'Supplier',
            'group_data' => 'supplier_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'supplier_province_code',
            'column_label' => 'Supplier State/Province Code',
            'default_order' => 28,
            'group' => 'Supplier',
            'group_data' => 'supplier_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'supplier_zip',
            'column_label' => 'Supplier Zip',
            'default_order' => 29,
            'group' => 'Supplier',
            'group_data' => 'supplier_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'supplier_country',
            'column_label' => 'Supplier Country',
            'default_order' => 30,
            'group' => 'Supplier',
            'group_data' => 'supplier_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'supplier_country_code',
            'column_label' => 'Supplier Country Code',
            'default_order' => 31,
            'group' => 'Supplier',
            'group_data' => 'supplier_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],

        //-----------------------------------------------------
        // Destination Info
        //-----------------------------------------------------

        [
            'data_name' => 'destination_info',
            'column_label' => 'Destination',
            'default_order' => 32,
            'group' => 'Destination',
            'group_data' => 'destination_info',
            'default_visible' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 0,
            'dropdown' => 0,
            'type' => 'destination_info',
        ],
        [
            'data_name' => 'destination_name',
            'column_label' => 'Destination Name',
            'default_order' => 33,
            'group' => 'Destination',
            'group_data' => 'destination_info',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'destination',
        ],
        [
            'data_name' => 'destination_email',
            'column_label' => 'Destination Email',
            'default_order' => 34,
            'group' => 'Destination',
            'group_data' => 'destination_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'destination',
        ],
        [
            'data_name' => 'destination_company',
            'column_label' => 'Destination Company',
            'default_order' => 35,
            'group' => 'Destination',
            'group_data' => 'destination_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'destination_phone',
            'column_label' => 'Destination Phone',
            'default_order' => 36,
            'group' => 'Destination',
            'group_data' => 'destination_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'destination_address',
            'column_label' => 'Destination Address',
            'default_order' => 37,
            'group' => 'Destination',
            'group_data' => 'destination_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'destination_city',
            'column_label' => 'Destination City',
            'default_order' => 38,
            'group' => 'Destination',
            'group_data' => 'destination_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'destination_province',
            'column_label' => 'Destination State/Province',
            'default_order' => 39,
            'group' => 'Destination',
            'group_data' => 'destination_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'destination_province_code',
            'column_label' => 'Destination State/Province Code',
            'default_order' => 40,
            'group' => 'Destination',
            'group_data' => 'destination_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'destination_zip',
            'column_label' => 'Destination Zip',
            'default_order' => 41,
            'group' => 'Destination',
            'group_data' => 'destination_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'destination_country',
            'column_label' => 'Destination Country',
            'default_order' => 42,
            'group' => 'Destination',
            'group_data' => 'destination_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'destination_country_code',
            'column_label' => 'Destination Country Code',
            'default_order' => 43,
            'group' => 'Destination',
            'group_data' => 'destination_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'destination',
        ],

        //-----------------------------------------------------
        // Items Info
        //-----------------------------------------------------

        [
            'data_name' => 'items',
            'column_label' => 'Items',
            'default_order' => 44,
            'group' => 'Items',
            'group_data' => 'items',
            'default_visible' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 0,
            'dropdown' => 0,
            'only_grouped' => 1,
            'type' => 'items',
        ],
        [
            'data_name' => 'quantity',
            'column_label' => 'Item Quantity',
            'default_order' => 45,
            'group' => 'Items',
            'group_data' => 'items',
            'default_visible' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'integer',
        ],
        [
            'data_name' => 'sku',
            'column_label' => 'Item SKU',
            'default_order' => 46,
            'group' => 'Items',
            'group_data' => 'items',
            'default_visible' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'item',
        ],
        [
            'data_name' => 'barcode',
            'column_label' => 'Item BARCODE',
            'default_order' => 46,
            'group' => 'Items',
            'group_data' => 'items',
            'default_visible' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 0,
            'dropdown' => 0,
            'type' => 'item',
        ],
        [
            'data_name' => 'supplier_sku',
            'column_label' => 'Supplier SKU',
            'default_order' => 47,
            'group' => 'Items',
            'group_data' => 'items',
            'default_visible' => 0,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'price',
            'column_label' => 'Item Price',
            'default_order' => 48,
            'group' => 'Items',
            'group_data' => 'items',
            'default_visible' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'decimal',
        ],
        [
            'data_name' => 'name',
            'column_label' => 'Item Name',
            'default_order' => 49,
            'group' => 'Items',
            'group_data' => 'items',
            'default_visible' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'nominal_code',
            'column_label' => 'Item Nominal Code',
            'default_order' => 50,
            'group' => 'Items',
            'group_data' => 'items',
            'default_visible' => 0,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'received',
            'column_label' => 'Item Received',
            'default_order' => 51,
            'group' => 'Items',
            'group_data' => 'items',
            'default_visible' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'decimal',
        ],
        [
            'data_name' => 'eta',
            'column_label' => 'Item ETA',
            'default_order' => 52,
            'group' => 'Items',
            'group_data' => 'items',
            'default_visible' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'date/time',
        ],
        [
            'data_name' => 'tax_rate',
            'column_label' => 'Item Tax Rate',
            'default_order' => 53,
            'group' => 'Items',
            'group_data' => 'items',
            'default_visible' => 0,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'decimal',
        ],

        //-----------------------------------------------------
        // Allocations Info
        //-----------------------------------------------------

        //    [
        //      'data_name'       => 'allocations',
        //      'column_label'    => 'Allocations',
        //      'default_order'   => 52,
        //      'group'           => 'Allocations',
        //      'group_data'      => 'allocations',
        //      'default_visible' => 0,
        //      'sortable'        => 0,
        //      'editable'        => 0,
        //      'filterable'      => 0,
        //      'dropdown'        => 0,
        //      'type'            => 'allocations',
        //    ],

        //-----------------------------------------------------
        // Statuses Info
        //-----------------------------------------------------

        [
            'data_name' => 'statuses',
            'column_label' => 'Statuses',
            'default_order' => 54,
            'group' => 'Statuses',
            'group_data' => 'statuses',
            'default_visible' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 0,
            'dropdown' => 0,
            'type' => 'statuses',
        ],
        [
            'data_name' => 'order_status',
            'column_label' => 'Order Status',
            'default_order' => 55,
            'group' => 'Statuses',
            'group_data' => 'statuses',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'submission_status',
            'column_label' => 'Submission Status',
            'default_order' => 56,
            'group' => 'Statuses',
            'group_data' => 'statuses',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'shipment_status',
            'column_label' => 'Shipment Status',
            'default_order' => 57,
            'group' => 'Statuses',
            'group_data' => 'statuses',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'receipt_status',
            'column_label' => 'Receipt Status',
            'default_order' => 58,
            'group' => 'Statuses',
            'group_data' => 'statuses',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'invoice_status',
            'column_label' => 'Invoice Status',
            'default_order' => 59,
            'group' => 'Statuses',
            'group_data' => 'statuses',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],

        //-----------------------------------------------------
        // Totals Info
        //-----------------------------------------------------

        [
            'data_name' => 'totals',
            'column_label' => 'Totals',
            'default_order' => 60,
            'group' => 'Totals',
            'group_data' => 'totals',
            'default_visible' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 0,
            'dropdown' => 0,
            'type' => 'totals',
        ],
        [
            'data_name' => 'additional_cost',
            'column_label' => 'Additional Cost',
            'default_order' => 61,
            'group' => 'Totals',
            'group_data' => 'totals',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'decimal',
        ],
        [
            'data_name' => 'tax_cost',
            'column_label' => 'Tax Cost',
            'default_order' => 62,
            'group' => 'Totals',
            'group_data' => 'totals',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'decimal',
        ],
        [
            'data_name' => 'discount',
            'column_label' => 'Discount',
            'default_order' => 63,
            'group' => 'Totals',
            'group_data' => 'totals',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'decimal',
        ],
        [
            'data_name' => 'product_total',
            'column_label' => 'Product Subtotal',
            'default_order' => 64,
            'group' => 'Totals',
            'group_data' => 'totals',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'decimal',
        ],
        [
            'data_name' => 'total',
            'column_label' => 'Total',
            'default_order' => 65,
            'group' => 'Totals',
            'group_data' => 'totals',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'decimal',
        ],
        [
            'data_name' => 'currency_code',
            'column_label' => 'Currency',
            'default_order' => 66,
            'group' => 'Totals',
            'group_data' => 'totals',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],

        //-----------------------------------------------------
        // Other Info
        //-----------------------------------------------------

        [
            'data_name' => 'tags',
            'column_label' => 'Tags',
            'default_order' => 67,
            'group' => 'Other',
            'group_data' => 'other',
            'default_visible' => 0,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'tags',
        ],

        //-----------------------------------------------------
        // Supplier Notes
        //-----------------------------------------------------

        [
            'data_name' => 'supplier_notes',
            'column_label' => 'Supplier Notes',
            'default_order' => 67,
            'group' => 'Supplier Notes',
            'group_data' => 'supplier_notes',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'other_date',
            'column_label' => 'Other Date',
            'default_order' => 69,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'date',
        ],
        [
            'data_name' => 'invoices',
            'column_label' => 'Invoices',
            'default_order' => 70,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'invoices',
        ],
        [
            'data_name' => 'total_quantity',
            'column_label' => 'Total Quantity',
            'default_order' => 71,
            'group' => 'Totals',
            'group_data' => 'totals',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'decimal',
        ],
        [
            'data_name' => 'asn_last_sent_at',
            'column_label' => 'ASN Last Sent At',
            'default_order' => 72,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'date',
        ],
        [
            'data_name' => 'asn_sent',
            'column_label' => 'ASN sent?',
            'default_order' => 73,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 0,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'boolean',
            'is_scope' => true
        ],
    ],
];
