<?php

return [
    'lwa_app_id' => env('LWA_APP_ID', ''),
    'lwa_client_id' => env('LWA_CLIENT_ID', ''),
    'lwa_client_secret' => env('LWA_CLIENT_SECRET', ''),
    'lwa_callback_url' => env('APP_URL').'/amazon/callback',
    'lwa_beta' => env('LWA_BETA', false),
    'aws_client_id' => env('AWS_CLIENT_ID', ''),
    'aws_client_secret' => env('AWS_CLIENT_SECRET', ''),
    'aws_secret_manager_name' => env('AWS_SECRET_MANAGER_NAME', ''),

    'url_authorize' => '/apps/authorize/consent',
    'url_access_token' => 'https://api.amazon.com/auth/o2/token',
    'get_orders_path' => '/orders/v0/orders',
    'reports_path' => '/reports/2021-06-30/',
    'regions' => [
        'NA' => [
            'baseUrl' => 'https://sellingpartnerapi-na.amazon.com',
            'awsRegion' => 'us-east-1',
            'timezone' => 'America/Los_Angeles'
        ],
        'EU' => [
            'baseUrl' => 'https://sellingpartnerapi-eu.amazon.com',
            'awsRegion' => 'eu-west-1',
            'timezone' => 'Europe/London'
        ],
    ]
];
