<?php

declare(strict_types=1);

namespace App\Utility;

class PhoneNumberUtility
{
    public static function applyMany($phoneNumber, array $rules): string
    {
        $mutablePhoneNumber = $phoneNumber;

        foreach ($rules as $rule) {
            $mutablePhoneNumber = self::$rule($mutablePhoneNumber);
        }

        return $mutablePhoneNumber;
    }

    public static function digitsOnly($phoneNumber): string
    {
        return preg_replace('/\D/', '', (string) $phoneNumber);
    }

    public static function withoutLeadingOne($phoneNumber): string
    {
        $checkForPatterns = ['+1', '1'];
        foreach ($checkForPatterns as $pattern) {
            if (strpos($phoneNumber, $pattern) === 0) {
                $patternLength = strlen($pattern);
                $phoneNumberLength = strlen($phoneNumber);

                return substr($phoneNumber, $patternLength);
            }
        }

        return $phoneNumber;
    }
}
