<?php

namespace App\Support;

use App\Support\Concurrency\ConcurrencyManager;
use Illuminate\Support\Facades\DB;
use Throwable;

class DatabaseConcurrencyManager implements ConcurrencyManager
{
    public function allOrNothing(callable $callable, int $attempts = 1): mixed
    {

        return retry($attempts, function () use ($callable) {
            DB::beginTransaction();

            try {
                $result = $callable();
                DB::commit();

                return $result;
            } catch (Throwable $e) {
                // TODO: Bright, review this logic
                // Only rollback if it is the last transaction level, otherwise there may be further error handling upstream
                if (DB::transactionLevel() == 1) {
                    DB::rollBack();
                } else {
                    // If we are not at transaction level 1, we must be at 2 or higher.  We need to still reduce the transaction level by 1
                    // Since we cannot do a rollback here, we should commit in order to reduce the transaction level by 1
                    DB::commit();
                }
                throw $e;
            }
        }, 5);
    }
}
