<?php

namespace App\Services\TaxRate;

use App\Models\TaxRate;

class TaxRateService
{
    public function getTaxRateForArray(array $taxRates)
    {
        $taxRates = collect($taxRates)->map(function ($taxRate) {
            if (is_null(@$taxRate['rate']) || ! is_numeric($taxRate['rate'])) {
                return null;
            }

            if (is_null(@$taxRate['name'])) {
                return null;
            }

            return [
                'rate' => $taxRate['rate'],
                'name' => $taxRate['name'],
            ];
        })
            ->filter()
            ->values();

        if ($taxRates->count() > 0) {
            $combinedName = $taxRates->pluck('name')->implode(' + ');
            $combinedRate = $taxRates->sum('rate');

            /*
             * TODO: This is problematic as it will pick an existing tax rate based on name, even though the rate could
             *  be different, leading to sales orders with incorrect tax rates.  Right now it can be mitigated by using
             *  the actual rate on the sales order line, not the one from the tax rate returned from this method.
             */

            $parentTaxrate = TaxRate::query()->firstOrCreate([
                'name' => $combinedName,
            ], [
                'rate' => $combinedRate,
            ]);

            foreach ($taxRates as $taxRate) {
                $parentTaxrate->taxRateLines()->firstOrCreate(array_merge($taxRate, ['tax_rate_id' => $parentTaxrate->id]));
            }

            return $parentTaxrate;
        }

        return null;
    }
}
