<?php

namespace App\Services\SalesOrder\Backorder;

use App\Models\BackorderQueue;

/**
 * Class MoveToBottomPriorityOrder.
 */
class MoveToBottomSingleQueuePriorityOrder extends SingleQueuePriorityOrder
{
    public function process(): BackorderQueue
    {
        $lastPriority = $this->queues->lastPriority($this->queue->getProductId());
        if ($lastPriority && $lastPriority->id != $this->queue->id) {
            /**
             * When moving a queue to the bottom,
             * coverages must be swapped with the
             * queue next in line as it will be pushed up.
             */
            $nextUpQueue = $this->queues->firstAfterPriority($this->queue->priority, $this->queue->getProductId());

            $currentPriority = $this->queue->priority;
            // We decrement the priorities after the queue's priority
            // and set the queue to the last priority.
            $this->queues->decrementPrioritiesAfter($currentPriority, $this->queue->getProductId(), 1, [$this->queue->id]);
            $this->queue->setPriority($lastPriority->priority);

            if ($nextUpQueue) {
                $this->swapCoverages($nextUpQueue->refresh(), $this->queue);
            }
        }

        return $this->queue;
    }
}
