<?php

namespace App\Services\SalesOrder\Backorder;

use App\Models\BackorderQueue;
use Illuminate\Contracts\Container\BindingResolutionException;
use InvalidArgumentException;
use Throwable;

class BulkMoveAboveIdPriorityOrder extends PriorityOrder
{
    /**
     * BulkMoveToTopPriorityOrder constructor.
     *
     *
     * @throws BindingResolutionException
     */
    public function __construct(array $options)
    {
        parent::__construct($options);

        if (empty($this->options) || ! isset($this->options['ids'])) {
            throw new InvalidArgumentException('ids option is required.');
        }

        if (empty($this->options) || ! isset($this->options['reference_id'])) {
            throw new InvalidArgumentException('reference_id option is required.');
        }
    }

    /**
     * {@inheritDoc}
     *
     * @throws Throwable
     */
    public function process()
    {
        foreach ($this->options['ids'] as $id) {
            $queue = $this->queues->findById($id);
            PriorityOrderFactory::make(
                BackorderQueue::REORDER_TYPE_MOVE_ABOVE_ID,
                $queue,
                [
                    'id' => $this->options['reference_id'],
                ]
            )->process();
        }

        $this->refreshCoverages();
    }
}
