<?php

namespace App\Services\SalesOrder\Actions;

use App\Data\SalesOrderLineData;
use App\Data\UpdateSalesOrderData;
use Closure;
use Spatie\LaravelData\Optional;

class DetectChangesThatShouldCauseSubmittedFulfillmentsToBeDeleted
{
    public function handle(UpdateSalesOrderData $data, Closure $next)
    {
        if ($data->payload->sales_order_lines instanceof Optional) {
            return $next($data);
        }

        $data->payload->sales_order_lines->each(function (SalesOrderLineData $lineData) use (&$data) {
            if ($lineData->salesOrderLine instanceof Optional) {
                $data->payload->deleteFulfillmentsReason = 'New sales order line added (' . $lineData->description . ')';
                $data->payload->shouldDeleteFulfillments = true;
            } elseif ($lineData->quantity != $lineData->salesOrderLine->quantity) {
                $data->payload->deleteFulfillmentsReason = 'Sales order line quantity changed';
                $data->payload->shouldDeleteFulfillments = true;
            }
        });

        return $next($data);
    }
}