<?php

namespace App\Services\SalesOrder\Actions;

use App\Data\SalesOrderLineData;
use App\Data\UpdateSalesOrderData;
use App\Models\SalesOrderLine;
use Closure;
use Exception;
use Spatie\LaravelData\Optional;

class DeleteRemovedSalesOrderLines
{
    /**
     * @throws Exception
     */
    public function handle(UpdateSalesOrderData $data, Closure $next)
    {
        if ($data->payload->sales_order_lines instanceof Optional) {
            return $next($data);
        }

        $linesIdsToDelete = $data
            ->payload
            ->sales_order_lines
            ->reject(fn (SalesOrderLineData $line) => $line->to_delete instanceof Optional)
            ->toCollection()
            ->filter(function (SalesOrderLineData $line) {
            return $line->to_delete;
        })->pluck('id');

        if ($linesIdsToDelete->isNotEmpty()) {
            SalesOrderLine::whereIn('id', $linesIdsToDelete)->each(fn (SalesOrderLine $line) => $line->delete());

            // Remove the deleted lines from the $data->payload->salesOrderLines
            $data->payload->sales_order_lines = $data->payload->sales_order_lines->reject(function (SalesOrderLineData $line) use ($linesIdsToDelete) {
                if ($line->id instanceof Optional) {
                    return false;
                }
                return $linesIdsToDelete->contains($line->id);
            });
        }

        return $next($data);
    }
}