<?php

namespace App\Services\SalesOrder\Actions;

use App\Data\SalesOrderLineData;
use App\Data\UpdateSalesOrderData;
use Closure;
use Exception;
use Spatie\LaravelData\Optional;

class CalculateFulfilledQuantity
{
    /**
     * @throws Exception
     */
    public function handle(UpdateSalesOrderData $data, Closure $next)
    {
        if ($data->payload->sales_order_lines instanceof Optional) {
            return $next($data);
        }

        $data->payload->sales_order_lines = $data->payload->sales_order_lines->map(function (SalesOrderLineData $line) {
            if ($line->salesOrderLine instanceof Optional) {
                return $line;
            }

            $salesOrderLine = $line->salesOrderLine;
            $line->fulfilled_quantity = $salesOrderLine->salesOrderFulfillmentLines->sum('quantity');

            return $line;
        });

        return $next($data);
    }
}