<?php

namespace App\Services\Receipts;

use App\Data\AdjustmentForReceiptData;
use App\Exceptions\InsufficientStockException;
use App\Models\InventoryAdjustment;
use App\Services\InventoryManagement\InventoryManager;
use Throwable;

trait CreatesAdjustmentForReceipt
{

    /**
     * @param  AdjustmentForReceiptData  $data
     * @return InventoryAdjustment
     * @throws InsufficientStockException
     * @throws Throwable
     */
    private function createAdjustment(
        AdjustmentForReceiptData $data,
    ): InventoryAdjustment
    {
        $adjustment = new InventoryAdjustment();
        $adjustment->warehouse_id = $data->warehouse_id;
        $adjustment->product_id = $data->product_id;
        $adjustment->quantity = $data->quantity;
        $adjustment->adjustment_date = $data->received_at;
        $adjustment->notes = $data->note;
        $adjustment->link_type = $data->link_type;
        $adjustment->link_id = $data->link_id;
        $adjustment->save();

        $manager = InventoryManager::with(
            warehouseId: $adjustment->warehouse_id,
            product: $adjustment->product,
            applicableFifoLayersForNegativeEvents: $data->applicable_fifo_layer_ids
        );

        if($data->quantity < 0){
            $manager->takeFromStock(abs($adjustment->quantity), $adjustment);
        } else {
            $manager->addToStock($adjustment->quantity, $adjustment);
        }

        return $adjustment;
    }

}