<?php

namespace App\Services\PurchaseOrder\PurchaseOrderBuilder\Builders;

use App\Models\Supplier;
use Illuminate\Contracts\Container\BindingResolutionException;
use Illuminate\Database\Eloquent\Collection;

class FillBackordersPurchaseOrderBuilder extends TargetStockLevelPurchaseOrderBuilder
{
    /**
     * @var array|mixed
     */
    protected array $salesFilters = [];

    /**
     * @throws BindingResolutionException
     */
    public function __construct(Supplier $supplier, array $options)
    {
        parent::__construct(
            quantity: 0,
            supplier: $supplier,
            destinationWarehouseId: $options['destination_warehouse_id'],
            productFilters: $options['product_filters']
        );

        $this->salesFilters = $options['sales_history_filters'] ?? [];
    }

    protected function getSupplierProducts(): Collection
    {
        // Apply the sales order filters to determine which products to purchase for.
        return $this->purchaseOrders->getBackordersAsInventoryAvailableWithSalesFilters(
            supplier: $this->supplier,
            warehouseId: $this->destinationWarehouseId,
            productFilters: $this->getProductFilters(),
            salesFilters: $this->salesFilters
        );
    }
}
