<?php

namespace App\Services\PurchaseOrder;

use App\Models\PurchaseOrder;
use App\Response;
use Illuminate\Http\Request;

class BulkSubmitPurchaseOrderService
{
    protected $request;

    private $response = [];

    private $errorsCount = 0;

    public function __construct(Request $request)
    {
        $this->request = $request;
    }

    public function submit(): array
    {
        set_time_limit(0);

        $this->getBuilder()->each(function (PurchaseOrder $purchaseOrder) {
            if (! $purchaseOrder->isOpen()) {
                $this->response[$purchaseOrder->id][] = Response::getError(__('messages.purchase_order.is_not_open'), 'PurchaseOrder'.Response::CODE_IS_NOT_OPEN, 'id');
                $this->errorsCount++;

                return; // continue
            }

            if (is_array($submissionResult = $purchaseOrder->submit())) {
                $this->response[$purchaseOrder->id][] = Response::getError(...$submissionResult);
                $this->errorsCount++;

                return; // continue
            }

            $this->response[$purchaseOrder->id] = __('messages.purchase_order.submit_to_supplier', ['id' => $purchaseOrder->purchase_order_number]);
        });

        return $this->response;
    }

    public function getErrorsCount(): int
    {
        return $this->errorsCount;
    }

    private function getBuilder()
    {
        $builder = PurchaseOrder::with([]);
        if ($this->request->has('ids')) {
            $builder->whereIn('id', array_unique($this->request->input('ids', [])));
        } else {
            // use advanced filter
            $builder->filter($this->request)->archived($this->request->input('archived', 0));
        }

        return $builder;
    }
}
