<?php

namespace App\Services\InventoryManagement;

use App\Models\FifoLayer;
use App\Models\InventoryMovement;

/**
 * Interface PositiveInventoryEvent
 */
interface PositiveInventoryEvent extends InventoryEvent
{
    /**
     * Creates the originating fifo layer
     * for the positive inventory event.
     * This is the entry point of new inventory
     * into the system.
     */
    public function createFifoLayer(int $quantity, ?float $unitCost = null, ?int $productId = null): FifoLayer;

    /**
     * Creates the inventory movements needed for the
     * positive inventory event.
     */
    public function createInventoryMovements(int $quantity, FifoLayer $fifoLayer): void;

    /**
     * Gets the originating inventory movement that
     * accompanies the addition of inventory
     */
    public function getOriginatingMovement(): ?InventoryMovement;

    /**
     * Gets the fifo layer for the positive event.
     */
    public function getFifoLayer(): ?FifoLayer;

    /**
     * Reassigns layers to the given movement and its siblings.
     * Note that the passed movement is the originating movement
     * for the event that consumes from this positive event.
     * For instance, When a purchase receipt is deleted and
     * sales orders are to be used to make up for used fifo layers,
     * the received movement will be the movement that created negative
     * active quantity for the sales order line.
     *
     * @param  InventoryMovement  $originatingMovement
     * @param  array  $layers
     */
    //  public function reassignLayersToMovement( InventoryMovement $originatingMovement, array $layers): void;

    /**
     * Gets the unit cost for the positive inventory event
     */
    public function getUnitCost(): float;

    public function backorderQueueReleases();
}
