<?php

namespace App\Services\InventoryManagement\Actions;

use App\Models\FifoLayer;
use App\Models\Product;
use Illuminate\Support\Facades\DB;

class ReleaseBackorderQueues
{
    public function release(array $productIds = []): array
    {
        $query = Product::with(['activeFifoLayers'])
            ->whereHas('activeFifoLayers');

        if (! empty($productIds)) {
            $query = $query->whereIn('id', $productIds);
        }

        $total = $query->count();
        $processed = 0;
        $errored = 0;
        $query
            ->cursor()
            ->each(function (Product $product) use (&$processed, &$errored) {
                DB::beginTransaction();

                try {
                    $product->activeFifoLayers()->each(function (FifoLayer $fifoLayer) use ($product) {
                        \App\Services\Product\ReleaseBackorderQueues::make($product)
                            ->execute($fifoLayer);
                    });
                    DB::commit();
                    $processed++;
                } catch (\Throwable $e) {
                    DB::rollBack();
                    $errored++;
                }

                $processed++;
            });

        return [$total, $processed, $errored];
    }
}
