<?php

namespace App\Services\Accounting\Actions\FinancialDocuments;

use App\Data\AccountingTransactionLineData;
use App\Enums\AccountingTransactionLineTypeEnum;
use App\Models\SalesOrderLine;
use Throwable;

class BuildAccountingTransactionLineDataFromSalesOrderLine
{
    public function __construct(
        private readonly SalesOrderLine $line,
    ) {}
    
    /**
     * @throws Throwable
     */
    public function handle(): AccountingTransactionLineData
    {
        return AccountingTransactionLineData::from([
            'type' => AccountingTransactionLineTypeEnum::SALES_INVOICE_LINE,
            'nominal_code_id' => $this->line->nominal_code_id,
            'description' => $this->getDescription(),
            'quantity' => $this->line->quantity,
            'amount' => $this->line->salesOrderLineFinancial->perUnit('revenue'),
            'tax_amount' => $this->line->tax_allocation_in_tenant_currency,
            'tax_rate_id' => $this->line->tax_rate_id,
            'link_id' => $this->line->id,
            'link_type' => SalesOrderLine::class,
        ]);
    }

    private function getDescription(): string
    {
        return ($this->line->product?->sku ? $this->line->product->sku . ': ' : '') . $this->line->description;
    }
}