<?php

namespace App\Services\Accounting\Actions\FinancialDocuments;

use App\Data\AccountingTransactionLineData;
use App\Enums\AccountingTransactionLineTypeEnum;
use App\Models\FinancialLine;
use Throwable;

class BuildAccountingTransactionLineDataFromFinancialLine
{
    public function __construct(
        private readonly FinancialLine $line,
    ) {}
    
    /**
     * @throws Throwable
     */
    public function handle(): AccountingTransactionLineData
    {
        return AccountingTransactionLineData::from([
            'type' => AccountingTransactionLineTypeEnum::SALES_INVOICE_LINE,
            'nominal_code_id' => $this->line->nominal_code_id,
            'description' => $this->line->description,
            'quantity' => $this->line->quantity,
            'amount' => $this->getAmount(),
            'tax_amount' => $this->line->tax_allocation_in_tenant_currency,
            'tax_rate_id' => null, // TODO: Revenue lines may need tax rate ids?
            'link_id' => $this->line->id,
            'link_type' => FinancialLine::class,
        ]);
    }

    private function getAmount(): string
    {
        return $this->line->amount_in_tenant_currency - ($this->line->salesOrder->is_tax_included ? $this->line->tax_allocation_in_tenant_currency : 0.00);
    }
}