<?php

namespace App;

use App\Models\SalesCredit;
use App\Models\SalesOrder;
use Illuminate\Database\Eloquent\Model;

/**
 * Class SalesCreditAllocation.
 *
 * @property-read int $id
 * @property int $sales_credit_id
 * @property-read float $amount
 * @property int $sales_order_id
 * @property SalesCredit $salesCredit
 * @property SalesOrder $salesOrder
 */
class SalesCreditAllocation extends Model
{
    /**
     * @var string
     */
    protected $table = 'sales_credit_allocations';

    /**
     * @var array
     */
    protected $fillable = ['sales_credit_id', 'sales_order_id', 'amount'];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo|SalesCredit
     */
    public function salesCredit()
    {
        return $this->belongsTo(SalesCredit::class);
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo|SalesOrder
     */
    public function salesOrder()
    {
        return $this->belongsTo(SalesOrder::class);
    }
}
