<?php

namespace App\SDKs\WalmartSDK;

class Utils
{
    /**
     * Get current timestamp in milliseconds.
     */
    public static function getMilliseconds(): float
    {
        return round(microtime(true) * 1000);
    }

    /**
     * Remove namespaces from XML.
     */
    public static function stripNamespacesFromXml(string $xml): string
    {
        $xml = preg_replace('/<[a-zA-Z0-9]+:/', '<', $xml);
        $xml = preg_replace('/<\/[a-zA-Z0-9]+:/', '</', $xml);
        $xml = preg_replace('/ xmlns:[a-zA-Z0-9]+=".*">/', '>', $xml);

        return $xml;
    }

    /**
     * Check if given array is assoc or sequential.
     */
    public static function is_assoc(array $array): bool
    {
        return (bool) count(array_filter(array_keys($array), 'is_string'));
    }

    public static function getIso8601Time($timestamp = null)
    {
        if ($timestamp === null) {
            $timestamp = time();
        }

        return date('c', $timestamp);
    }
}
