<?php

namespace App\SDKs\ShipStation\Services;

use App\SDKs\ShipStation\ShipStation;
use Illuminate\Support\Facades\Http;

class Warehouses extends ShipStation
{

    public function getList(string $actionUrl = '')
    {
        $response = Http::baseUrl($this->base_url)
            ->withHeaders([
                'Content-Type' => 'application/json',
            ])
            ->withBasicAuth(static::$config['apiKey'], static::$config['apiSecret'])
            ->get(trim($this->getRequestUrl($actionUrl), '/'));

        return $response->json();
    }

}