<?php

namespace App\SDKs\ShipStation\Services;

use App\SDKs\ShipStation\ShipStation;

class Carriers extends ShipStation
{
    /**
     * List all shipping providers connected to the account.
     */
    public function getList(): array
    {
        return $this->request();
    }

    /**
     * Retrieves the shipping carrier account details for the specified carrierCode.
     */
    public function view(string $carrierCode): array
    {
        return $this->request("/getcarrier?carrierCode={$carrierCode}");
    }

    /**
     * Retrieves the list of available shipping services provided by the specified carrier.
     */
    public function getServices(string $carrierCode): array
    {
        return $this->request("/listservices?carrierCode={$carrierCode}");
    }

    /**
     * Retrieves a list of packages for the specified carrier.
     */
    public function getPackages(string $carrierCode): array
    {
        return $this->request("/listpackages?carrierCode={$carrierCode}");
    }
}
