<?php

namespace App\SDKs\ShipStation\Model;

/**
 * Class Weight.
 *
 * @property float $value
 * @property string $units units of weight. Allowed units are: "pounds", "ounces", or "grams"
 * @property-read float $WeightUnits (read only) A numeric value that is equivalent to the above units field.
 */
class Weight extends Model
{
    const UNIT_POUNDS = 'pounds';

    const UNIT_OUNCES = 'ounces';

    const UNIT_GRAMS = 'grams';

    const UNITS = [self::UNIT_POUNDS, self::UNIT_OUNCES, self::UNIT_GRAMS];
}
