<?php

namespace App\SDKs\ShipStation\Model;

use Illuminate\Support\Facades\Validator;

trait Validatable
{
    /**
     * Rules of model.
     */
    abstract public function rules(): array;

    /**
     * Attribute names for validation.
     */
    abstract public function customAttributes(): array;

    /**
     * Validate model data.
     *
     * @return array errors
     */
    public function validate(): array
    {
        return Validator::make($this->toArray(), $this->rules(), [], $this->customAttributes())->errors()->toArray();
    }
}
