<?php

namespace App\Rules;

use App\Abstractions\HasNotesInterface;
use Closure;
use Illuminate\Contracts\Validation\ValidationRule;

class ValidLinkTypeRule implements ValidationRule
{
    /**
     * Run the validation rule.
     *
     * @param  \Closure(string): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        if (!class_exists($value)) {

            $fail('The link_type must be a valid class.');
        }
        $model = app($value);
        if (!$model instanceof HasNotesInterface) {
            $fail('The link_type must implement HasNotesInterface.');
        }
    }
}
