<?php

namespace App\Rules;

use App\Models\Warehouse;
use Closure;
use Illuminate\Contracts\Validation\ValidationRule;

class StandardWarehouseRule implements ValidationRule
{
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        $warehouse = Warehouse::findOrFail($value);

        if ($warehouse->type != Warehouse::TYPE_DIRECT && $warehouse->type != Warehouse::TYPE_3PL) {
            $fail("$warehouse->name is a $warehouse->type warehouse, it must be a direct or 3PL warehouse.");
        }
    }
}
