<?php

namespace App\Repositories;

use App\Models\WarehouseTransfer;
use App\Models\WarehouseTransferLine;
use Illuminate\Support\Collection;

class WarehouseTransferLineRepository
{
    public function getUnderReceivedLinesForWarehouseTransfer(WarehouseTransfer $warehouseTransfer): Collection
    {
        return WarehouseTransferLine::where('warehouse_transfer_id', $warehouseTransfer->id)
            ->get()
            ->filter(function (WarehouseTransferLine $line) {
                return $line->quantity > $line->quantity_received;
            });
    }

    public function getOverReceivedLinesForWarehouseTransfer(WarehouseTransfer $warehouseTransfer): Collection
    {
        return WarehouseTransferLine::where('warehouse_transfer_id', $warehouseTransfer->id)
            ->get()
            ->filter(function (WarehouseTransferLine $line) {
                return $line->quantity < $line->quantity_received;
            });
    }
}
