<?php

namespace App\Repositories;

use App\Models\TrackedJobLog;
use Carbon\Carbon;

class TrackedJobLogRepository
{
    public function deleteLogsOlderThan(int $days): void
    {
        $deleteBeforeDate = Carbon::now()->subDays($days);

        // Delete the records older than 7 days
        TrackedJobLog::query()->where('created_at', '<', $deleteBeforeDate)->delete();
    }
}
