<?php

namespace App\Repositories\Shopify;

use App\Models\IntegrationInstance;
use App\Models\Shopify\ShopifyOrder;
use Carbon\Carbon;
use Modules\Amazon\Entities\AmazonOrder;

class ShopifyOrderRepository
{
    public function getShopifyOrderCreatedDateRangeForMissingSequences(IntegrationInstance $integrationInstance, $start_date, $end_date): ?array
    {
        $shopifyOrders = ShopifyOrder::query()
            ->where('integration_instance_id', $integrationInstance->id)
            ->whereBetween('created_at', [
                Carbon::parse($start_date),
                Carbon::parse($end_date),
            ])
            ->orderBy('number')
            ->get();

        $sequence = null;
        $created_at_start = null;
        $created_at_end = null;

        /** @var ShopifyOrder $shopifyOrder */
        foreach ($shopifyOrders as $shopifyOrder) {
            if (empty($sequence)) {
                $sequence = $shopifyOrder->number;
                $created_at_start = $shopifyOrder->created_at;
                $created_at_end = $shopifyOrder->created_at;
            }

            if ($sequence != $shopifyOrder->number) {
                $created_at_start = min($created_at_start, $shopifyOrder->created_at);
                $created_at_end = max($created_at_end, $shopifyOrder->created_at);
                $sequence = $shopifyOrder->number;
            }

            $sequence++;
        }

        return [
            'created_at_start' => $created_at_start,
            'created_at_end' => $created_at_end,
        ];
    }

    public function getNewestDate(string $modelClass): ?Carbon
    {
        return Carbon::parse(AmazonOrder::query()
            ->select('LastUpdatedDate')
            ->latest('LastUpdatedDate')
            ->first()
            ->pluck('LastUpdatedDate'));
    }
}
