<?php

namespace App\Repositories;

use App\Models\ShippingCarrier;
use App\Models\ShippingMethod;
use Illuminate\Database\Eloquent\Model;

class ShippingCarrierRepository
{
    public function save(string $name, ?string $tracking_link = null): ShippingCarrier|Model
    {
        return ShippingCarrier::query()->updateOrCreate(['name' => $name], [
            'tracking_link' => $tracking_link,
        ]);
    }

    public function findOrCreateMethodForCarrier(string $carrierName, string $methodName = 'Unspecified'): ShippingMethod
    {
        $carrier = ShippingCarrier::query()->where('name', $carrierName)->firstOrCreate(
            ['name' => $carrierName]
        );

        return ShippingMethod::query()
            ->firstOrCreate([
                'name' => $methodName,
                'shipping_carrier_id' => $carrier->id,
            ]);
    }
}
