<?php

namespace App\Repositories;

use App\DTO\SalesOrderLineLayerDto;
use App\Models\FifoLayer;
use App\Models\SalesOrderLine;
use App\Models\SalesOrderLineLayer;
use Illuminate\Support\Collection;

class SalesOrderLineLayerRepository
{
    public function create(SalesOrderLineLayerDto $data): SalesOrderLineLayer
    {
        return SalesOrderLineLayer::create($data->toArray());
    }

    public function saveBulk(Collection $data): void
    {
        SalesOrderLineLayer::query()->upsert(
            $data->toArray(),
            ['layer_id', 'layer_type']
        );
    }

    public function getLayersForSalesOrderLineFifoLayer(SalesOrderLine $salesOrderLine, FifoLayer $fifoLayer): Collection
    {
        return SalesOrderLineLayer::query()
            ->where('sales_order_line_id', $salesOrderLine->id)
            ->where('layer_id', $fifoLayer->id)
            ->where('layer_type', FifoLayer::class)
            ->get();
    }
}
