<?php

namespace App\Repositories;

use App\Abstractions\Integrations\IntegrationInstanceInterface;
use App\Models\IntegrationInstance;
use App\Models\SalesChannel;

class SalesChannelRepository
{
    public function saveFromIntegrationInstance(IntegrationInstance|IntegrationInstanceInterface $integrationInstance): void
    {
        $salesChannel = new SalesChannel([
            'store_id' => $integrationInstance->integration_settings['store_id'],
        ]);
        $salesChannel->integrationInstance()->associate($integrationInstance);
        $salesChannel->save();
    }

    public function delete(SalesChannel $salesChannel): void
    {
        $salesChannel->delete();
    }
}
