<?php

namespace App\Repositories;

use App\Contracts\Repositories\Repository as RepositoryContract;
use Exception;
use Illuminate\Database\Eloquent\Collection as EloquentCollection;
use Illuminate\Database\Eloquent\Model;

/**
 * Class RepositoryAbstract.
 */
class RepositoryAbstract implements RepositoryContract
{
    protected string $modelClassName;

    /**
     * @throws Exception
     */
    protected function checkClassName()
    {
        if (! class_exists($this->modelClassName)) {
            throw ( new Exception('Repository '.get_class($this).' needs to have $this->modelClassName defined.') );
        }
    }

    /**
     * @throws Exception
     */
    public function create(array $attributes): Model
    {
        $this->checkClassName();

        return call_user_func_array("$this->modelClassName::create", [$attributes]);
    }

    /**
     * Get all the models from the database.
     *
     * @param  array|mixed  $columns
     *
     * @throws Exception
     */
    public function all($columns = ['*']): EloquentCollection
    {
        $this->checkClassName();

        return call_user_func_array("$this->modelClassName::all", [$columns]);
    }

    public function find($id, $columns = ['*']): Model|EloquentCollection
    {
        $this->checkClassName();

        return call_user_func_array("$this->modelClassName::find", [$id, $columns]);
    }

    /**
     * Destroy the models for the given IDs.
     *
     * @param  array|int  $ids
     *
     * @throws Exception
     */
    public function destroy($ids): int
    {
        $this->checkClassName();

        return call_user_func_array("$this->modelClassName::destroy", [$ids]);
    }
}
