<?php

namespace App\Repositories;

use App\Models\PurchaseOrderShipmentReceiptLine;
use Illuminate\Support\Collection;

class PurchaseOrderShipmentReceiptLineRepository
{
    public function getReceiptLinesFromShipmentLineIds(int $receiptId, array $shipmentLineIds): Collection
    {
        return PurchaseOrderShipmentReceiptLine::with('purchaseOrderShipmentLine.purchaseOrderLine')
            ->whereIn('purchase_order_shipment_line_id', $shipmentLineIds)
            ->where('purchase_order_shipment_receipt_id', $receiptId)
            ->get();
    }
}
