<?php

namespace App\Repositories;

use App\Models\PurchaseOrderShipmentLine;
use Illuminate\Support\Collection;

class PurchaseOrderShipmentLineRepository
{
    public function getShipmentLinesFromPurchaseOrderLineIds(int $shipmentId, array $purchaseOrderLineIds): Collection
    {
        return PurchaseOrderShipmentLine::whereIn('purchase_order_line_id', $purchaseOrderLineIds)
            ->where('purchase_order_shipment_id', $shipmentId)
            ->get();
    }
}
